-- Chat.lua
-- Copyright (c) 2001 Marcio M. Andrade

-- Infrared chat program.
-- Requires two devices with PalmOS >= 3.3.
-- Write a message and tap Send to send it to your party.
-- See messages your party sent in the Replies field.
-- Tap Stop to quit.

pclear()
w,h = pmode()

pfont(1) print("Message:") pfont(0)
msgf = pfield(1,30,30) pnl() pnl()

sendb = pbutton("Send")
stopb = pbutton("Stop") pnl() pnl() pnl()

pfont(1) print("Replies:") pfont(0)
replyf = pfield(5,30,1024) pnl() pnl()

clearb = pbutton("Clear")

f = openser("ir0", 9600, "8N1")

nl = ""

while 1 do
  ev,id = pevent()
  if ev == ioPending then
    s = read(f, 30)
    if s ~= nil then
      psettext(replyf, pgettext(replyf)..nl..s)
      nl = "\n"
    end
  elseif ev == ctlSelect then
    if id == sendb then
      write(f, pgettext(msgf))
      psettext(msgf, "")
      nl = "\n"
    elseif id == stopb then
      break
    elseif id == clearb then
      psettext(replyf, "")
      nl = ""
    end
  end
end

closeser(f)
